/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.pulsar;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.apache.pulsar.client.api.MessageListener;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.pulsar.MessageEnhanceRequiredInfo;

public class PulsarConsumerListenerInterceptor
implements InstanceMethodsAroundInterceptor {
    public static final String OPERATE_NAME_PREFIX = "Pulsar/";
    public static final String CONSUMER_OPERATE_NAME = "/Consumer/MessageListener";

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        return ret == null ? null : (MessageListener & Serializable)(consumer, message) -> {
            MessageEnhanceRequiredInfo requiredInfo = (MessageEnhanceRequiredInfo)((EnhancedInstance)message).getSkyWalkingDynamicField();
            if (requiredInfo == null || requiredInfo.getContextSnapshot() == null) {
                ((MessageListener)ret).received(consumer, message);
            } else {
                AbstractSpan activeSpan = ContextManager.createLocalSpan((String)(OPERATE_NAME_PREFIX + requiredInfo.getTopic() + CONSUMER_OPERATE_NAME));
                activeSpan.setComponent((Component)ComponentsDefine.PULSAR_CONSUMER);
                SpanLayer.asMQ((AbstractSpan)activeSpan);
                Tags.MQ_TOPIC.set(activeSpan, requiredInfo.getTopic());
                ContextManager.continued((ContextSnapshot)requiredInfo.getContextSnapshot());
                try {
                    ((MessageListener)ret).received(consumer, message);
                }
                catch (Exception e) {
                    ContextManager.activeSpan().log((Throwable)e);
                }
                finally {
                    ContextManager.stopSpan();
                }
            }
        };
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
    }
}

