/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.toolkit.activation.trace;

import java.lang.reflect.Method;
import java.util.Map;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.util.CustomizeExpression;
import org.apache.skywalking.apm.agent.core.util.MethodUtil;
import org.apache.skywalking.apm.toolkit.activation.ToolkitPluginConfig;
import org.apache.skywalking.apm.toolkit.activation.util.TagUtil;
import org.apache.skywalking.apm.toolkit.trace.Tag;
import org.apache.skywalking.apm.toolkit.trace.Tags;
import org.apache.skywalking.apm.toolkit.trace.Trace;

public class BaseTraceAnnotationInterceptor {
    void beforeMethod(Method method, Object[] allArguments) {
        Tag tag;
        Trace trace = method.getAnnotation(Trace.class);
        String operationName = trace.operationName();
        if (operationName.length() == 0 || ToolkitPluginConfig.Plugin.Toolkit.USE_QUALIFIED_NAME_AS_OPERATION_NAME) {
            operationName = MethodUtil.generateOperationName((Method)method);
        }
        AbstractSpan localSpan = ContextManager.createLocalSpan((String)operationName);
        Map context = CustomizeExpression.evaluationContext((Object[])allArguments);
        Tags tags = method.getAnnotation(Tags.class);
        if (tags != null && tags.value().length > 0) {
            for (Tag tag2 : tags.value()) {
                if (TagUtil.isReturnTag(tag2.value()).booleanValue()) continue;
                TagUtil.tagParamsSpan(localSpan, context, tag2);
            }
        }
        if ((tag = method.getAnnotation(Tag.class)) != null && !TagUtil.isReturnTag(tag.value()).booleanValue()) {
            TagUtil.tagParamsSpan(localSpan, context, tag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void afterMethod(Method method, Object ret) {
        try {
            Tag tag;
            if (ret == null) {
                return;
            }
            AbstractSpan localSpan = ContextManager.activeSpan();
            Map context = CustomizeExpression.evaluationReturnContext((Object)ret);
            Tags tags = method.getAnnotation(Tags.class);
            if (tags != null && tags.value().length > 0) {
                for (Tag tag2 : tags.value()) {
                    if (!TagUtil.isReturnTag(tag2.value()).booleanValue()) continue;
                    TagUtil.tagReturnSpanSpan(localSpan, context, tag2);
                }
            }
            if ((tag = method.getAnnotation(Tag.class)) != null && TagUtil.isReturnTag(tag.value()).booleanValue()) {
                TagUtil.tagReturnSpanSpan(localSpan, context, tag);
            }
        }
        finally {
            ContextManager.stopSpan();
        }
    }

    void handleMethodException(Throwable t) {
        if (ContextManager.isActive()) {
            ContextManager.activeSpan().log(t);
        }
    }
}

