/*
 * Decompiled with CFR 0.152.
 */
package com.bytesflow.opencv.media.test;

import com.bytesflow.opencv.media.jni.PQCVMediaProcessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class OpenCVImageBlurTest {
    private static String sIMAGE_PATH = "/Users/devyk/Downloads/IMG_3067.PNG";
    private static String sSO_PATH = "/Users/devyk/Data/Project/sample/github_code/OpenCVSample/output/lib/libpiaoquan_java_opencv.dylib";

    public static void main(String[] args) {
        int count = 10;
        if (args.length > 0) {
            sIMAGE_PATH = args[0];
            sSO_PATH = args[1];
            count = Integer.parseInt(args[2]);
        }
        try {
            PQCVMediaProcessor.initSDK(sSO_PATH);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        ExecutorService executorService = Executors.newFixedThreadPool(count);
        while (true) {
            long startTime = System.currentTimeMillis();
            CountDownLatch countDownLatch = new CountDownLatch(count);
            for (int i = 0; i < count; ++i) {
                executorService.execute(new ImageBlurRunable(countDownLatch));
            }
            try {
                countDownLatch.await();
                System.out.println("const time = " + (System.currentTimeMillis() - startTime));
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private static void blurTest() {
        try {
            String path = sIMAGE_PATH;
            int ret = PQCVMediaProcessor.blurDetectionFromImagePath(path);
            System.out.println("PQCVMediaProcessor path = " + ret);
            File file = new File(path);
            byte[] images = new byte[(int)file.length()];
            FileInputStream fileInputStream = new FileInputStream(file);
            fileInputStream.read(images);
            ret = PQCVMediaProcessor.blurDetectionFromImageBytes(images);
            fileInputStream.close();
            System.out.println("PQCVMediaProcessor bytes = " + ret);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class ImageBlurRunable
    implements Runnable {
        private CountDownLatch countDownLatch;

        public ImageBlurRunable(CountDownLatch countDownLatch) {
            this.countDownLatch = countDownLatch;
        }

        @Override
        public void run() {
            OpenCVImageBlurTest.blurTest();
            this.countDownLatch.countDown();
        }
    }
}

